<?php

if ( ! class_exists( 'ITSEC_Malware_Scheduling_Setup' ) ) {
	class ITSEC_Malware_Scheduling_Setup {
		private $defaults;
		
		public function __construct() {
			global $itsec_setup_action;
			
			$this->defaults = array(
				'enabled'             => false,
				'email_notifications' => true,
				'email_contacts'      => array(),
			);
			
			if ( isset( $itsec_setup_action ) ) {
				switch ( $itsec_setup_action ) {
					case 'activate':
						$this->execute_activate();
						break;
					case 'upgrade':
						$this->execute_upgrade();
						break;
					case 'deactivate':
						$this->execute_deactivate();
						break;
					case 'uninstall':
						$this->execute_uninstall();
						break;
				}
			} else {
				wp_die( 'error' );
			}
		}
		
		/**
		 * Execute module activation.
		 *
		 * @since 4.0
		 *
		 * @return void
		 */
		public function execute_activate() {
			$options = get_site_option( 'itsec_malware_scheduling' );
			
			if ( $options === false ) {
				add_site_option( 'itsec_malware_scheduling', $this->defaults );
			}
		}
		
		/**
		 * Execute module deactivation
		 *
		 * @return void
		 */
		public function execute_deactivate() {
			global $wpdb;
			
			$wpdb->query( "DELETE FROM `" . $wpdb->base_prefix . "options` WHERE `option_name` LIKE ('%itsec_malware_scheduling_last_scans%')" );
		}
		
		/**
		 * Execute module uninstall
		 *
		 * @return void
		 */
		public function execute_uninstall() {
			$this->execute_deactivate();
			
			delete_site_option( 'itsec_malware_scheduling' );
			delete_site_option( 'itsec_malware_scheduling_report_queue' );
		}
		
		/**
		 * Execute module upgrade
		 *
		 * @return void
		 */
		public function execute_upgrade() {
			global $itsec_old_version;
			
			if ( $itsec_old_version < 4037 ) {
				$options = get_site_option( 'itsec_malware_scheduling' );
				
				if ( is_array( $options ) ) {
					unset( $options['standard'] );
					unset( $options['standard_interval'] );
					unset( $options['individual'] );
				} else {
					$options = array();
				}
				
				
				$options = array_merge( $this->defaults, $options );
				
				update_site_option( 'itsec_malware_scheduling', $options );
				
				delete_site_option( 'itsec_malware_scheduling_report_queue' );
				delete_site_option( 'itsec_malware_scheduling_last_scan' );
				
				
				require_once( dirname( __FILE__ ) . '/class-itsec-malware-scheduling-admin.php' );
				ITSEC_Malware_Scheduling_Admin::update_schedule( $options['enabled'] );
			}
		}
	}
}

new ITSEC_Malware_Scheduling_Setup();
