<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class WC_AF_Rule_Velocities extends WC_AF_Rule {

	private $start_datetime_string = '';
	private $end_datetime_string = '';

	/**
	 * The constructor
	 */
	public function __construct() {
		parent::__construct( 'velocities', 'IP address ordered multiple orders in the last 24 hours.', 25 );
	}

	/**
	 * Add the date range condition to the SQL
	 *
	 * @param string $where
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return string
	 */
	public function date_range( $where = '' ) {
		$where .= " AND ( `post_date` >= '" . $this->start_datetime_string . "' AND `post_date` <= '" . $this->end_datetime_string . "' )";

		return $where;
	}

	/**
	 * Do the required check in this method. The method must return a boolean.
	 *
	 * @param WC_Order $order
	 *
	 * @since  1.0.0
	 * @access public
	 *
	 * @return bool
	 */
	public function is_risk( WC_Order $order ) {
		global $wpdb;

		// Default risk is false
		$risk = false;


		// Set the default order types
		$order_types = array( 'shop_order' );

		// wc_get_order_types() is a 2.2+ function
		if ( function_exists( 'wc_get_order_types' ) ) {
			$order_types = wc_get_order_types( 'order-count' );
		}

		// Calculate the new datetime
		$dt = new DateTime( $order->post->post_date );
		$dt->modify( '-24 hours' );

		// Set the start and send datetime strings
		$this->start_datetime_string = $dt->format( 'Y-m-d H:i:s' );
		$this->end_datetime_string   = $order->post->post_date;

		// Add date range filter
		add_filter( 'posts_where', array( $this, 'date_range' ) );

		// Get the Same IP Orders
		$velocities_orders = get_posts( array(
				'posts_per_page'   => - 1,
				'post_type'        => $order_types,
				'post__not_in'     => $order->ID,
				'post_status'      => array( 'wc-completed', 'wc-processing', 'wc-on-hold' ),
				'suppress_filters' => false,
				'fields'           => 'ids',
				'meta_query'       => array(
					array(
						'key'     => '_customer_ip_address',
						'value'   => $_SERVER['REMOTE_ADDR'],
						'compare' => '='
					)
				)
			)
		);

		// Remove date range filter
		remove_filter( 'posts_where', array( $this, 'date_range' ) );

		// Check if there are orders with same IP
		if ( count( $velocities_orders ) > 0 ) {

			$risk = true;

		}

		return $risk;
	}

}