<?php

/**
 * Plugin Name: WooCommerce PickingPal
 * Plugin URI: http://woothemes.com/products/woocommerce-pickingpal
 * Description: Helps achieve 100% order picking & shipping accuracy. Never send out an incomplete order or the wrong items to your Customers ever again. Scan your order barcode, scan your items, and let PickingPal do the rest!
 * Author: PickingPal
 * Author URI: http://pickingpal.com/
 * Version: 1.2.0
 * Text Domain: woocommerce-pickingpal
 * Domain Path: /i18n/languages/
 *
 * Copyright: (c) 2014,2015 RTD LLC. (rtddev@ribbedtee.com)
 *
 * License: GNU General Public License v3.0
 * License URI: http://www.gnu.org/licenses/gpl-3.0.html
 *
 * @package     woocommerce-pickingpal
 * @author      RTD LLC
 * @Category    Plugin
 * @copyright   Copyright (c) 2014, RTD LLC
 * @license     http://www.gnu.org/licenses/gpl-3.0.html GNU General Public License v3.0
 */
if ( !defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

/**
 * Required functions
 */
if ( !function_exists( 'woothemes_queue_update' ) ) {
	require_once( 'woo-includes/woo-functions.php' );
}

/**
 * Plugin updates
 */
woothemes_queue_update( plugin_basename( __FILE__ ), '7e2bf1e3609302c9b90b56dc9e24972e', '675401' );

if ( !is_woocommerce_active() ) {
	return;
}

// Required functions
if ( !function_exists( 'woothemes_queue_update' ) ) {
	require_once( 'woo-includes/woo-functions.php' );
}
include 'classes/class-wc-pickingpal-updater.php';
include 'classes/class-wc-pickingpal.php';

$wc_pickingpal = new WC_PickingPal();
register_activation_hook( __FILE__, array( $wc_pickingpal, 'activation' ) );

add_action( 'wp_ajax_p_action', array( $wc_pickingpal, 'ajax_action' ) );
add_action( 'plugins_loaded', 'wc_pickingpal_load_textdomain' );

function wc_pickingpal_load_textdomain() {
	load_plugin_textdomain( 'woocommerce-pickingpal', false, dirname( plugin_basename( __FILE__ ) ) . '/i18n/languages' );
	if ( !function_exists( "wc_get_product" ) ) {

		function wc_get_product( $the_product = false, $args = array() ) {
			return WC()->product_factory->get_product( $the_product, $args );
		}

	}
}

//// -=-=-= Example =-=-=-
//$f = function($fields) {
//	$fields['custom field'] = '';
//	return $fields;
//};
//add_filter( 'wc_pickingpal_custom_fields', $f, 10 );
//
//$f2 = function( $product, $field ) {
//	switch ( $field ) {
//		case 'custom field':
//			return $product->price;
//			break;
//	}
//};
//add_filter( 'wc_pickingpal_custom_field_value', $f2, 10, 2 );

