<link rel="stylesheet" type="text/css" href="<?php echo $url ?>list.css">
<div class="page">


	<?php
	
	foreach ( $orders as $order ) {
		$order_number = ltrim( $order->get_order_number(), '#' );
		?>
		<div>
		<?php
		$img = get_option( 'pickingpal-logo' );
		if ( $img ) {
			?>
				<img src="<?php echo $img ?>" class="logo">
				<?php
			}
			?>
		</div>
		<div class="info">
	<?php echo nl2br( get_option( 'pickingpal-contact' ) ); ?>
		</div>
		<div class="clearfix"></div>
		<div class="border-x"></div>
		<div class="info1">
			<table>
				<tr>
					<td>
						<h3><?php echo __( 'Billing Address', 'woocommerce-pickingpal' ) ?></h3>
						<div class="info2">
	<?php echo $order->get_formatted_billing_address(); ?>
						</div>
					</td>
					<td>
						<h3><?php echo __( 'Shipping Address', 'woocommerce-pickingpal' ) ?></h3>
						<div class="info2">
	<?php echo $order->get_formatted_shipping_address(); ?>
						</div>
					</td>
					<td>
						<h3><?php echo __( 'Shipping method', 'woocommerce-pickingpal' ) ?></h3>
						<div class="info2">
	<?php echo $order->get_shipping_method(); ?>
						</div>
					</td>
					<td>
						<h3><?php echo __( 'Total amount', 'woocommerce-pickingpal' ) ?></h3>
						<div>
	<?php echo $order->get_formatted_order_total(); ?>
						</div>
						<div>
	<?php echo $order->post_date; ?>
						</div>
					</td>
				</tr>
			</table>
		</div>
		<div class="barcode">
			<div><?php echo __( 'Invoice', 'woocommerce-pickingpal' ) ?> #<?php echo $order_number; ?></div>
			<font face="IDAutomationHC39M">(<?php echo $order_number; ?>)</font>
		</div>
		<table class="products-list">
			<tr class="item-line">
				<th class="header-list"><?php echo __( 'Order Item', 'woocommerce-pickingpal' ) ?></th>
				<th class="header-list"><?php echo __( 'Price', 'woocommerce-pickingpal' ) ?></th>
				<th class="header-list"><?php echo __( 'Quantity', 'woocommerce-pickingpal' ) ?></th>
				<th class="header-list"><?php echo __( 'Subtotal', 'woocommerce-pickingpal' ) ?></th>
			</tr>
	<?php
	foreach ( $order->get_items() as $item ) {

		$_product = $order->get_product_from_item( $item );

		$sku		 = $variation	 = '';

		if ( $_product )
			$sku			 = $_product->get_sku();
		$item_meta		 = new WC_Order_Item_Meta( $item[ 'item_meta' ] );
		$variation_data	 = $item_meta->get_formatted();
		if ( $_product && !empty( $variation_data ) ) {
			$variation = array();
			foreach ( $variation_data as $var ) {
				$variation[] = $var[ 'label' ] . ': ' . $var[ 'value' ];
			}
			$variation	 = implode( ' | ', $variation );
			$variation	 = str_replace( 'attribute_', '', $variation );
		}

		if ( $order->display_cart_ex_tax || !$order->prices_include_tax ) {
			$ex_tax_label	 = ( $order->prices_include_tax ) ? 1 : 0;
			$price			 = wc_price( $order->get_line_subtotal( $item ), array( 'ex_tax_label' => $ex_tax_label ) );
		} else {
			$price = wc_price( $order->get_line_subtotal( $item, TRUE ) );
		}
		?>
				<tr class="item-line">
					<td>
						<div><?php echo apply_filters( 'woocommerce_order_product_title', $item[ 'name' ], $_product ) ?></div>
						<div><?php echo $variation ?></div>
						<div>SKU: <?php echo $sku ?></div>
					</td>
					<td>
		<?php echo $_product->get_price(); ?>
					</td>
					<td><?php echo $item[ 'qty' ] ?></td>
					<td><?php echo $price ?></td>
				</tr>
		<?php
	}
	?>
			<tr class="total-x">
				<td></td>
				<td></td>
				<td class="item-line"><?php echo __( 'Subtotal', 'woocommerce-pickingpal' ) ?>:</td>
				<td class="item-line">
	<?php echo $order->get_formatted_order_total(); ?>
				</td>
			</tr>
			<tr class="total-x">
				<td></td>
				<td></td>
				<td class="item-line"><?php echo __( 'Shipping', 'woocommerce-pickingpal' ) ?>:</td>
				<td class="item-line"><?php echo $order->get_shipping_to_display(); ?></td>
			</tr>
			<tr class="total-x">
				<td></td>
				<td></td>
				<td class="item-line"><?php echo __( 'Discount', 'woocommerce-pickingpal' ) ?>:</td>
				<td class="item-line">
	<?php echo wc_price( $order->order_discount ); ?>
				</td>
			</tr>
			<tr class="total">
				<td></td>
				<td></td>
				<td>Total:</td>
				<td>
	<?php echo wc_price( $order->order_total ); ?> 
				</td>
			</tr>
		</table>
		<p class="pagebreak"></p> 
	<?php
}
?>
</div>
<script>
	window.print()
</script>
