<?php
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>


<h2>

	<?php echo _e( 'Pick Ticket Template', 'woocommerce-pickingpal' ) ?>
</h2>
<input type="hidden" id="ovr_sku" value="<?php echo $WC_PickingPal->override_sku; ?>">
<form method="post"  action="<?php echo admin_url( 'admin.php?page=PickingPal&tab=settings' ) ?>">
    <table class="wp-picking-table-settings">
        <tr>
            <td class="table-td-align-top">
                <span class="header-2"><?php echo _e( 'Banner Image URL' ) ?></span>
                <img class="help_tip" data-tip="ddd" src="<?php echo $url ?>../woocommerce/assets/images/help.png" title="<?php echo _e( 'Choose a logo for top left of the Pick Ticket. Use Select image button to select an image from the Media Library, or to upload a new one.', 'woocommerce-pickingpal' ) ?>" height="16" width="16">
            </td>
            <td>
                <input type="text" name="url_file" id="url_file" value="">
                <input type="button" class="button" id="upload_logo_button" value="<?php echo _e( 'Select image', 'woocommerce-pickingpal' ) ?>">
            </td>
        </tr>
        <tr>
            <td>

            </td>
            <td>
                <div>
					<?php
					if ( $logo ) {
						?>
						<div class="delete-logo">
							<img src="<?php echo $logo ?>">
							<input type="hidden" name="delete_logo" value="1"><br>
							<a href="<?php echo admin_url( 'admin.php?page=PickingPal&tab=settings&delete_logo=1' ) ?>"><?php _e( 'Remove logo', 'woocommerce-pickingpal' ) ?></a>
						</div>

						<?php
					}
					?>

                </div>
            </td>
        </tr>
        <tr>
            <td class="table-td-align-top">
                <span class="header-2"><?php echo _e( 'Company Information', 'woocommerce-pickingpal' ) ?>:</span>
                <img class="help_tip" src="<?php echo $url ?>../woocommerce/assets/images/help.png" title="<?php echo _e( 'Enter up to 5-6 lines of Company Contact information. Text will be placed in upper right of the Pick Ticket', 'woocommerce-pickingpal' ) ?>" height="16" width="16">
            </td>
            <td>
                <div>
                    <textarea name="contact" class="pickingpal-contact"><?php echo get_option( 'pickingpal-contact' ); ?></textarea>
                </div>
            </td>
        </tr>

        <tr>
            <td>
                Quantity Override
                SKU
                <img class="help_tip" data-tip="ddd" src="<?php echo $url ?>../woocommerce/assets/images/help.png" title="<?php echo _e( 'Click link to print the Quantity Override SKU barcode. See Docs for instructions.', 'woocommerce-pickingpal' ) ?>" height="16" width="16">
            </td>
            <td>
                <a href="#" id="print_ovr_sku">Print Quantity Override SKU</a>
            </td>
        </tr>

        <tr>
            <td class="table-td-align-top">
                <span class="header-2"><?php echo _e( 'Export Setup', 'woocommerce-pickingpal' ) ?></span>

            </td>
            <td >
                <div class="table-export">

                    <div class="tb-row ">
                        <div class="tb-col ">
                            <h3><?php echo _e( 'Select Export Fields', 'woocommerce-pickingpal' ) ?>
                                <img class="help_tip" style="margin: 0 0 0 2px;float: none" data-tip="sss" src="<?php echo $url ?>../woocommerce/assets/images/help.png" title="<?php echo _e( 'Select items for export. See Docs for instructions.', 'woocommerce-pickingpal' ) ?>" height="16" width="16">
                            </h3>
                        </div>
                        <div class="tb-col ">
                            <h3><?php echo _e( 'Export Field Order (Drag to reorder)', 'woocommerce-pickingpal' ) ?></h3>
                        </div>
                    </div>
                    <div class="tb-row">
                        <div class="tb-col ">

                            <div class="woocommerce-pickingpal-table padding-5">
								<?php
								$wcpp	 = WC_PickingPal::getInstance();
								$fields	 = $wcpp->get_fields();

								foreach ( $fields as $field => $value ) {
									?>
									<div class="row clearfix2" data-field="<?php echo $field ?>">

										<div class="col1"><?php echo $field ?></div>
										<div class="col2"><input class="wc-field" type="checkbox" value="1" name="fields[<?php echo $field ?>]" <?php echo!empty( $value ) ? 'checked' : '' ?>></div>
									</div>
									<?php
								}
								?>
                                <div style="padding: 15px 5px">
                                    <a class="button"  href="edit.php?post_type=product&page=product_attributes"><?php echo _e( 'Add New Attribute', 'woocommerce-pickingpal' ) ?></a>
                                </div>
                            </div>
                        </div>
                        <div class="tb-col ">

                            <div class="woocommerce-pickingpal-table active-fields padding-5">

								<?php
								$wcpp			 = WC_PickingPal::getInstance();
								$active_fields	 = get_option( 'wc-picking-pal-active-fields' );
								if ( !empty( $active_fields ) ) {
									foreach ( $active_fields as $field => $value ) {
										?>
										<div class="row clearfix2" data-field="<?php echo $field ?>">
											<input type="hidden" name="active_fields[<?php echo $field ?>]" value="1">
											<div class="col1"><?php echo $field ?></div>
										</div>
										<?php
									}
								}
								?>

                            </div>
                        </div>
                    </div>
                </div>
            </td>
        </tr>
        <tr class="table-td-align-top">
            <td >
            </td>
            <td>

            </td>
        </tr>
        <tr>
            <td>
                <input type="submit" class="button-primary" value="<?php echo _e( 'Save changes', 'woocommerce-pickingpal' ) ?>">
            </td>
            <td></td>
        </tr>
    </table>
</form>
<div class="row clearfix2 wc-template" data-field="">
    <input type="hidden" name="" value="1">
    <div class="col1"></div>
</div>
<script>
	jQuery( document ).ready( function( $ ) {

		// Tooltips
		var tiptip_args = {
			'fadeIn': 50,
			'fadeOut': 50,
			'delay': 200
		};


		$( function() {
			$( ".help_tip" ).tipTip( tiptip_args );
		} );


	} );
	jQuery( document ).ready( function( $ ) {
		var custom_uploader;
		$( '#upload_logo_button' ).click( function( e ) {
			e.preventDefault();
			if ( custom_uploader ) {
				custom_uploader.open();
				return;
			}

			custom_uploader = wp.media.frames.file_frame = wp.media( {
				title: 'Choose Banner',
				button: {
					text: 'Choose Banner'
				},
				multiple: false
			} );

			custom_uploader.on( 'select', function() {
				attachment = custom_uploader.state().get( 'selection' ).first().toJSON();
				$( '#url_file' ).val( attachment.url );
			} );

			custom_uploader.open();
		} );
		$( ".woocommerce-pickingpal-table" ).sortable();
		$( ".woocommerce-pickingpal-table" ).disableSelection();
		$( '.wc-field' ).click( function() {
			var v = $( this ).attr( 'checked' );
			var row = $( this ).closest( '.row' );
			var field = row.attr( 'data-field' );
			if ( typeof ( v ) !== 'undefined' ) {
				var a_f = $( '.active-fields' ).find( '.row[data-field="' + field + '"]' );
				if ( a_f.length == 0 ) {
					var template = $( '.wc-template' ).clone().removeClass( 'wc-template' )
					template.attr( 'data-field', field );
					template.find( 'input' ).attr( 'name', 'active_fields[' + field + ']' );
					template.find( '.col1' ).html( field );
					template.appendTo( '.active-fields' );
				}
			} else {
				var a_f = $( '.active-fields' ).find( '.row[data-field="' + field + '"]' )
				a_f.remove()
			}
		} )

        $('#print_ovr_sku').click(function() {
            print_ovr_sku(this);
            return false;
        });
	} );


    function print_ovr_sku(item) {
		var url="<?php echo wp_nonce_url( admin_url( '?print_list=3' ), 'print_list' ); ?>"
		var w = window.open( url, 'print', 'width=800,height=600' );
		w.focus()
        return false;
    }

</script>
