<?php
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>
<div style="padding-right:20px;">
    <audio id="audio_order_load" src="<?php echo $url ?>sounds/01-load-order-sound.mp3" preload="auto"  ></audio>
    <audio id="audio_item_success" src="<?php echo $url ?>sounds/02-pick-item-success-sound.mp3" preload="auto"  ></audio>
    <audio id="audio_item_error" src="<?php echo $url ?>sounds/03-pick-item-error-sound.mp3" preload="auto"  ></audio>
    <audio id="audio_order_complete" src="<?php echo $url ?>sounds/04-pick-order-complete-sound.mp3" preload="auto"  ></audio>

    <div style="position: relative;">
        <div class="p_input">
            <span class="label_input_pp"><?php echo _e( 'Order Number', 'woocommerce-pickingpal' ) ?>:</span>
            <input type="text" id="order_id" value="">
            <input type="button" class="button" id="load_order" value="<?php _e( 'Load', 'woocommerce-pickingpal' ) ?>">
        </div>
        <div class="p_input">
            <span class="label_input_pp"><?php echo _e( 'Product SKU', 'woocommerce-pickingpal' ) ?>: </span>
            <input type="text" id="product_sku" value="">
            <input type="button" class="button" id="pick" value="<?php _e( 'Pick', 'woocommerce-pickingpal' ) ?>">
			<?php add_thickbox(); ?>
            <a id="thickbox" class='thickbox' href='#TB_inline?width=0&height=0&inlineId=override' style="display: none;"></a>
        </div>
        PP-OVRD-ITM-QTY
        <div id="override">
            <h1>Override item</h1>
			<table>
				<tr>
					<td>
						<label for="product_sku_over"><?php echo _e( 'Product SKU', 'woocommerce-pickingpal' ) ?>:&nbsp;</label>
					</td>
					<td >
						<input style="width: 170px;" type="text" id="product_sku_over">
					</td>
					<td>
						<input type="button" class="button" id="load_product_over" value="<?php _e( 'Load', 'woocommerce-pickingpal' ) ?>">
					</td>
					<td>
						<input type="text" id="product_qty_over" size="3" placeholder="<?php echo _e( 'Qty', 'woocommerce-pickingpal' ) ?>">
					</td>
					<td>
						<input type="button" class="button" id="pick_over" value="<?php _e( 'Pick', 'woocommerce-pickingpal' ) ?>" >
					</td>
				</tr>
				<tr>
					<td colspan="4" style="border: 1px solid #ddd;padding: 4px;height: 28px">
						<span style="" id="product_title_over"></span><span id="product_qty_label_over" style="float: right;"></span>
					</td>
				</tr>
			</table>



        </div>
        <div class="p_input reset_picking_status" style="display: none; float: right; line-height:30px;">
            <span><?php echo _e( 'Picking Status', 'woocommerce-pickingpal' ) ?>: </span>
			<input type="button" class="button"  id="reset" value="<?php _e( 'Reset', 'woocommerce-pickingpal' ) ?>">

        </div>
    </div>
    <div class="order_status">
        <div class="order_status_t" style="float:left;"><?php _e( 'Order Status', 'woocommerce-pickingpal' ) ?>:&nbsp;</div> <span id="order_status"></span>
        <div class="clearfix"></div>
    </div>
    <div id="progressbar">
        <div class="progress-label"></div>
    </div>
    <div id="status-x"></div>
    <div class="view-items">
        <div class="unpicked">
            <div class="item-header"><?php _e( 'Unpicked items', 'woocommerce-pickingpal' ) ?></div>
            <div class="items"></div>
        </div>
        <div class="picked">
            <div class="item-header"><?php _e( 'Picked items', 'woocommerce-pickingpal' ) ?></div>
            <div class="items"></div>
        </div>
    </div>


    <div class="clearfix"></div>

    <div class="view-back-items">
        <div class="back-unpicked">
            <div class="item-header"><?php _e( 'Unpicked items (backordered)', 'woocommerce-pickingpal' ) ?></div>
            <div class="items"></div>
        </div>
        <div class="back-picked">
            <div class="item-header"><?php _e( 'Picked items (backordered)', 'woocommerce-pickingpal' ) ?></div>
            <div class="items"></div>
        </div>
    </div>
    <div class="clearfix"></div>
    <div style="text-align: right;">

        <button  data-url="<?php echo wp_nonce_url( admin_url( '?print_list=2&ids[0]=order_id' ), 'print_list' ); ?>" class="button button-primary" id="print_slip">Print Packing Slip</button>
    </div>
</div>




<script>
	var SKU = [ ];
	var ovr_sku;
	function stop_sounds( )
	{
		audio_order_load.pause( );
		audio_order_load.currentTime = 0;
		audio_item_success.pause( );
		audio_item_success.currentTime = 0;
		audio_item_error.pause( );
		audio_item_error.currentTime = 0;
		audio_order_complete.pause( );
		audio_order_complete.currentTime = 0;
	}

	var url = '<?php echo $url ?>';
	( function( $ ) {




		$.extend( {
			playSound: function( ) {
				return $( "<audio autoplay='autoplay' style='display:none;' controls='controls'><source src='" + arguments[0] + ".mp3' /><source src='" + arguments[0] + ".ogg' /></audio>" ).appendTo( 'body' );
			}
		} );
	} )( jQuery );
	var progress_bar = jQuery( '#progressbar' );
	var progress_label = jQuery( '.progress-label' );
	jQuery( document ).ready( function( $ ) {

		var items;
		$( '#order_id' ).focus( )
		progress_bar.progressbar( {
			value: " ",
			change: function( ) {
				progress_label.text( progress_bar.progressbar( "value" ) + "%" );
			},
		} )
		var progressbar_value = progress_bar.find( ".ui-progressbar-value" )


		$( '#order_id' ).keypress( function( ev ) {
			var l = $( this ).val( ).length
			if ( ev.charCode == 13 && l > 0 ) {
				load_items( )
			}
		} )
		$( '#load_order' ).click( function( ) {
			var l = $( '#order_id' ).val( ).length
			if ( l > 0 ) {
				load_items( )
			}
		} )

		$( '#load_product_over' ).click( function( ) {
			var sku = jQuery( '#product_sku_over' ).val();
			var index = items.find_by_sku( sku );
			if ( index !== false ) {
				jQuery( '#product_title_over' ).html( items.get_item_title( index ) );
				jQuery( '#product_qty_label_over' ).text( items.get_item_count_by_sku( sku ) );
				stop_sounds();
				audio_item_success.play();
			}
			else {
				jQuery( '#product_title_over' ).html( 'Product not found' );
				jQuery( '#product_qty_label_over' ).text( '' );
				stop_sounds();
				audio_item_error.play();
			}


		} )

		$( '#product_sku' ).keypress( function( ev ) {
			var l = $( this ).val( ).length
			if ( ev.charCode == 13 && l > 0 ) {
				items.search( )
			}

		} )

		$( '#pick' ).click( function( ) {
			var l = $( '#product_sku' ).val( ).length
			if ( l > 0 ) {
				items.search( )
			}
		} )

		$( '#pick_over' ).click( function( ) {
			var l = $( '#product_sku_over' ).val( ).length
			var l2 = $( '#product_qty_over' ).val( ).length
			if ( ( l > 0 ) && ( l2 > 0 ) ) {
				ovr_sku = $( '#product_sku_over' ).val();
				items.search_over();
			}
		} )

		$( '#product_sku_over' ).keypress( function( ev ) {
			var l = $( this ).val( ).length
			if ( ev.charCode == 13 && l > 0 ) {
				$( '#load_product_over' ).click( )
				$( '#product_qty_over' ).focus()
			}
		} )

		$( '#product_qty_over' ).keypress( function( ev ) {
			var l = $( this ).val( ).length
			if ( ev.charCode == 13 && l > 0 ) {
				$( '#pick_over' ).click( )
			}
		} )
		$( '#cancel_over' ).click( function( ) {
			$( "#override" ).hide();
		} )

		$( '#reset' ).click( function() {
			var order_id = $( '#order_id' ).val()
			jQuery.post( ajax, { action: 'p_action', p_act: 'reset_order', 'order_id': order_id }, function( data ) {
				load_items( )
			} )
		} )
		$( '#status-x' ).html( text['Scan Order'] );
		$( '#status-x' ).removeClass( ).addClass( 'scan-order' );
		progress_bar.progressbar( "value", 0 )
		function load_items( ) {
			delete items;
			items = new Items( );
			progressbar_value.css( { 'background-color': '#808080' } )

			$( '#status-x' ).html( text['Scan Order'] );
			$( '#status-x' ).removeClass( ).addClass( 'scan-order' );
			progress_bar.progressbar( "value", null )
			progress_label.text( ' ' );
			items.events.after_load.add( function( ) {
//                console.log(items.order)
				if ( items.order != null ) {
					loaded_order_id = items.order.id;
					$( '#print_slip' ).show();
					
					$( '#product_sku' ).focus( )
					
					if ( items.order_picked == "0" ) {
						$( '#status-x' ).html( text['Order Loaded'] );
						$( '#status-x' ).removeClass( ).addClass( 'order-loaded' );
					} else {
						$( '#status-x' ).html( text['Order Loaded (PICKED)'] );
						$( '#status-x' ).removeClass( ).addClass( 'order-picked' );
					}
					if ( items.items.picked.length > 0 ) {
						$( '.reset_picking_status' ).show();
					} else {
						$( '.reset_picking_status' ).hide();
					}
				} else {
					$( '#status-x' ).html( text['Order Not Found'] );
					$( '#status-x' ).removeClass( ).addClass( 'order-not-found' );
					
					loaded_order_id = 0;
					$( '#print_slip' ).hide();
				}
			} )

			items.load_items( )
			items.events.after_searching.add( function(  ) {

//				console.log( 'order id = ' + order_id );
				if ( items.last_search === false ) {
					jQuery( '#status-x' ).html( text['product not found'] );
					jQuery( '#status-x' ).removeClass( ).addClass( 'not-found' )
				} else {
					$( '.reset_picking_status' ).show();
					jQuery( '#status-x' ).html( text['product found'] );
					jQuery( '#status-x' ).removeClass( ).addClass( 'found' )
					console.log( items.order_items )
//					if ( items.status == 'processing' ) {
//					jQuery.post( ajax, { action: 'p_action', p_act: 'update_picking_processing', id: items.order_items.order.id, 'sku': SKU, is_ovr: ( ovr_sku == SKU[0] ? 1 : '' ) }, function( data ) {
//					} )
//					}
				}
			} )
			var order_id = $( '#order_id' ).val()
			items.events.after_pick.add( function( item, order_id ) {
				console.log( item )
				if ( item !== false ) {
					jQuery.post( ajax, { action: 'p_action', p_act: 'pick', 'item': item, 'order_id': order_id, id: items.order_items.order.id, 'sku': SKU, pick_arr:items.items.picked }, function( data ) {
						console.log( data )
					} )
				}
			}, order_id )
			items.events.completed.add( function( ) {

				
				$( '#order_id' ).val( '' )
				$( '#order_id' ).focus( )

				progressbar_value.css( { 'background-color': '#85bb65' } )
			} )

		}

		jQuery( '#print_slip' ).click( function() {
//            var href = $( this ).attr( 'href' );
//			var order_id = jQuery( '#order_id' ).val()
			var url = $( this ).attr( 'data-url' );
			
			if (loaded_order_id ==  0)
					return false;
			var order_id = loaded_order_id;
			
			url = url.replace( 'order_id', order_id )
			var w = window.open( url, 'print', 'width=800,height=600' );
			w.focus()
			return false;
		} )

	} )

	function clone( obj ) {
		if ( null == obj || "object" != typeof obj )
			return obj;
		var copy = obj.constructor();
		for ( var attr in obj ) {
			if ( obj.hasOwnProperty( attr ) )
				copy[attr] = obj[attr];
		}
		return copy;
	}

</script>