<?php
/**
 * Admin View: Notice - Update
 */
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div id="message" class="updated pickingpal-message">
	<p><?php _e( '<strong>PickingPal Update Required</strong> &#8211; This update includes a new feature related to printing Pick Tickets. We need to update your installation to support this new feature. For details, please see release notes.', 'woocommerce-pickingpal' ); ?></p>
	<p class="submit"><a href="<?php echo esc_url( add_query_arg( 'do_update_pickingpal', 'true', $_SERVER[ 'PHP_SELF' ] ) ); ?>" class="pickingpal-update-now button-primary"><?php _e( 'Run the updater', 'woocommerce-pickingpal' ); ?></a></p>
</div>
<script type="text/javascript">
	jQuery( '.pickingpal-update-now' ).click( 'click', function() {
		var answer = confirm( '<?php _e( 'It is strongly recommended that you backup your database before proceeding. Are you sure you wish to run the updater now?', 'woocommerce-pickingpal' ); ?>' );
		return answer;
	} );
</script>
