<?php
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>
<h2><?php _e( 'Barcode Labels Export', 'woocommerce-pickingpal' ) ?>
    <img style="margin: 0 0 0 3px;" class="help_tip" data-tip="ddd" src="<?php echo $url ?>../woocommerce/assets/images/help.png" title="<?php echo _e( 'Use filters below to narrow export list. Fill Qty fields. Select all or some items with row selector, then click Export.', 'woocommerce-pickingpal' ) ?>" height="16" width="16">
</h2>


<form method="post" action="admin.php?action=p_action&p_act=export" id="pickingpal">
    <div class="wp-table2"></div>
    <div class="bot_btn">
        <input type="submit" class="btn-export button-primary" value="<?php _e( 'Export (*.CSV)', 'woocommerce-pickingpal' ) ?>">

    </div>    
</form>

<script>
	var ajaxurl = '<?php echo $ajaxurl ?>';
	var url = '<?php echo $url ?>';

	jQuery( document ).ready( function( $ ) {

		// Tooltips
		var tiptip_args = {
			'fadeIn': 50,
			'fadeOut': 50,
			'delay': 200
		};


		$( function() {
			$( ".help_tip" ).tipTip( tiptip_args );
		} );
		$( '.btn-export' ).click( function() {
			var l = $( '.wp-table2' ).find( 'input[type=checkbox]:checked' ).length;
			if ( l == 0 ) {
				alert( '<?php _e( 'Please select one or more items.', 'woocommerce-pickingpal' ) ?>' )
				return false;
			}

		} )

	} );
	jQuery( document ).ready( function( $ ) {
		var action = 'wp_export_table'

		function wp_table( target ) {
			var that = this;
			this.columns = { }
			this.events = {
				after_update: new Callback(),
			}

			this.update = function( query ) {
				$.get( ajaxurl, query, function( data ) {
					$( target ).html( data )
					init()
					that.events.after_update.run();
				}, 'html' )
			}
			function init() {
				var cols = $( target ).find( 'table thead th' );

				$.each( cols, function( i, col ) {
					var name = $( col ).attr( 'id' );
					that.columns[name] = {
						index: i - 1
					}
				} )
			}
			this.get_rows = function() {
				return $( target ).find( 'table tbody tr' );
			}


		}


		var table = new wp_table( '.wp-table2' );
		table.update( 'action=p_action&p_act=' + action );
		table.events.after_update.add( init );
		table.events.after_update.add( function() {
			var columnWidths = new Array();
			var wrap = $( '<div class="wrap777"></div>' )
			$( ".wp-table2 table" ).after( wrap );
			$( ".wp-table2 table" ).appendTo( wrap )
			// Get column widths

			// get column data for header
			var tableHeaderRow = $( ".wp-table2 table thead" ).clone();

			var hr = $( '<table id="headerRowNew"></table>' );
			hr.appendTo( 'body' )
			tableHeaderRow.appendTo( hr )
			var wrap888 = $( '<div class="wrap888"></div>' )
			wrap.before( wrap888 )
			$( '#headerRowNew' ).appendTo( wrap888 )
			$( '#headerRowNew' ).addClass( 'wp-list-table widefat fixed' )
			$( 'input[id^=cb-select-all]' ).click( function() {
				var f = $( this ).attr( 'checked' );
				if ( f == 'checked' ) {
					$( '.wp-table2 .check-column' ).find( 'input' ).attr( 'checked', 1 )
				} else {
					$( '.wp-table2 .check-column' ).find( 'input' ).removeAttr( 'checked' )
				}
			} )
			$( '#headerRowNew th' ).find( 'a' ).click( function() {
				var query = $( this ).attr( 'href' ).split( '?' )[1];
				table.update( 'action=p_action&p_act=' + action + '&' + query )
				return false;
			} )
		} );
		function init() {
			$( '#search-submit' ).click( function() {
				var query = 'action=p_action&p_act=' + action + '&' + $( '#pickingpal' ).serialize()
				table.update( query )
				return false;
			} )
			$( '#product_name' ).keypress( function( e ) {
				if ( e.keyCode == 13 ) {
					var query = 'action=p_action&p_act=' + action + '&' + $( '#pickingpal' ).serialize()
					table.update( query )

					return false;

				}
			} )
			$( '.wp-table2 th' ).find( 'a' ).click( function() {
				var query = $( this ).attr( 'href' ).split( '?' )[1];
				table.update( 'action=p_action&p_act=' + action + '&' + query )
				return false;
			} )
			var n_qty = table.columns['qty'].index;

			var rows = table.get_rows();

			var input = $( '<input>' );
			$.each( rows, function( i, row ) {
				var qty = $( row ).find( 'td:eq(' + n_qty + ')' )
				var v = $( qty ).html();
				$( qty ).empty()
				var input_templ = input.clone().appendTo( qty );
				var img = $( '<img src="' + url + '/img/preloader.gif" class="preloader">' )
				input_templ.val( v )
				input_templ.addClass( 'input_template' );
				img.appendTo( input_templ.parent( 'td' ) )
				var t = 0;
				var post_id = $( qty ).closest( 'tr' ).find( '.id' ).html();

				input_templ.keyup( function( h ) {
					clearTimeout( t );
					var th = this
					img.show()
					t = setTimeout( function() {
						var action = 'save_qty';
						var value = $( th ).val();
						$.post( ajax, 'action=p_action&p_act=' + action + '&value=' + value + '&post_id=' + post_id, function( data ) {
							img.hide()
						}, 'JSON' )
					}, 1000 )

				} )
			} )

		}

	} )


</script>
