function Items() {
    this.order = null;
    this.order_items = null;
    this.items = {
        unpicked: [ ],
        picked: [ ],
        count: 0,
        count_picked: 0
    };
    this.events = {
        after_load: new Callback(),
        before_load: new Callback(),
        after_searching: new Callback(),
        completed: new Callback(),
        after_pick: new Callback(),
    }
    var that = this;
    this.status = 'processing'
    this.last_search = false;
    this.order_picked = null;
    this.load_completed = false;
    this.load_items = function() {
        that.events.before_load.run();
        this.clear_picked_items()
        var action = 'load_order';
        var order_id = jQuery( '#order_id' ).val();
        var succ = false;

        jQuery.ajax( {
            type: "POST",
            url: ajax,
            dataType: "json",
            async: false,
            data: { action: 'p_action', p_act: action, order_id: order_id },
            success: function( order_items ) {
                //console.log( order_items );
                that.override_sku = order_items.override_sku;
                that.order_items = order_items;
                that.order = null;
                if ( order_items.order.post != null && order_items.order.post.post_type == 'shop_order' ) {
                    that.order = order_items.order;
                    that.order_picked = order_items.picked;

                    progress_bar.progressbar( "value", 0 );
                    jQuery( '#order_status' ).html( order_items.order.post_status )

                    ///START backorder malaya krov'
                    jQuery.each( order_items.products, function( index, item ) {
                        if ( item.backordered > 0 ) {
                            item.qty -= item.backordered;
                            var bitem = clone( item );
                            delete bitem.backordered;
                            bitem.qty = item.backordered;
                            bitem.backorder = 1;
                            order_items.products.push( bitem );
                        }
                        if ( item.qty <= 0 )
                            order_items.products.splice( index, 1 );
                    } )
                    ///END backorder malaya krov'
                    //console.log(order_items.products);

                    jQuery.each( order_items.products, function( index, item ) {
                        that.create_item( index, item );
                        if ( item.isparent !== 1 )
                            that.items.count += parseInt( item.qty );
                    } )
                    
                    if ( order_items.SKU )
                        jQuery.each( order_items.SKU, function( index, item ) {
                            console.log(item)
                            that.search_processing( item );
                        } );
                    //jQuery.playSound(url + 'sounds/01-load-order-sound')
                    succ = true;
                    //console.log( that.items )
                } else {
                    //jQuery.playSound(url + 'sounds/03-pick-item-error-sound')

                    succ = false;
                }
                that.load_completed = true;
            },
        } );

        if ( succ )
        {
            stop_sounds();
            audio_order_load.play();
        } else {
            stop_sounds();
            audio_item_error.play();
            jQuery( '#order_status' ).html( "" )
        }

        that.events.after_load.run();

    }
    this.create_item = function( index, item ) {
        var target_unpicked = false;
        var target_picked = false;



        if ( item.picked > 0 && item.qty !== 0 ) {
            this.items.unpicked[index] = item;
            this.items.picked[index] = jQuery.extend( this.items.picked[index], item );
            this.items.picked[index].qty = parseInt( item.picked );
            target_unpicked = jQuery( '.unpicked .items' );
            target_picked = jQuery( '.picked .items' );
        }
        if ( item.qty == 0 ) {
            this.items.picked[index] = jQuery.extend( this.items.picked[index], item );
            this.items.picked[index].qty = parseInt( item.picked );
            target_picked = jQuery( '.picked .items' );
        }
        if ( item.picked == 0 ) {
            this.items.unpicked[index] = item;
            if ( item.backorder !== 1 )
                target_unpicked = jQuery( '.unpicked .items' );
            else
                target_unpicked = jQuery( '.back-unpicked .items' );
        }
//        if (item.bundled_items && item.sku) {

//            var bundled = [];
//            jQuery.each(item.bundled_items, function(index_b, b) {
//                bundled.push(b.name);
//            })
//            var html = "<br><div class='bundled_item'><div>" + (bundled.join("</div><div>")) + "</div></div>";
//            var v_item = jQuery('<div class="item" data-index="' + index + '"><div class="item-name">' + item.name + '</div><div class="item-quantity">' + item.qty + '</div>' + html + '</div>');
//
//        }
//        else 

        if ( target_unpicked ) {

            if ( item.isparent === 1 ) {
                var v_item = jQuery( '<div class="parent_item" data-index="' + index + '"><div class="item-name">' + item.name + '</div><div class="item-quantity">' + item.qty + '</div></div>' );
                jQuery( target_unpicked ).append( v_item );

            } else if ( item.parent !== -1 )
            {
                var parent = jQuery( target_unpicked ).find( '.parent_item[data-index=' + item.parent + ']' );

                var v_item = jQuery( '<div class="item" data-index="' + index + '"><div class="item-name">' + item.name + '</div><div class="item-quantity">' + item.qty + '</div></div>' );
                jQuery( parent ).append( v_item );
            }
            else {
                var v_item = jQuery( '<div class="item" data-index="' + index + '"><div class="item-name">' + item.name + '</div><div class="item-quantity">' + item.qty + '</div></div>' );
                jQuery( target_unpicked ).append( v_item );

            }

        }

        if ( target_picked ) {
            if ( item.isparent === 1 ) {
                var v_item = jQuery( '<div class="parent_item" data-index="' + index + '"><div class="item-name">' + item.name + '</div><div class="item-quantity">' + item.picked + '</div></div>' );
                jQuery( target_picked ).append( v_item );
            } else if ( item.parent !== -1 )
            {
                var parent = jQuery( target_picked ).find( '.parent_item[data-index=' + item.parent + ']' );
                if ( parent.length == 0 ) {
                    var parent_i = this.items.unpicked[item.parent];
                    this.items.picked[item.parent] = jQuery.extend( this.items.picked[item.parent], parent_i );
                    this.items.picked[item.parent].qty = parent_i.picked;
                    var parent = jQuery( '<div class="parent_item" data-index="' + item.parent + '"><div class="item-name">' + parent_i.name + '</div><div class="item-quantity">' + parent_i.picked + '</div></div>' );
                    jQuery( target_picked ).append( parent );
                }
                var v_item = jQuery( '<div class="item" data-index="' + index + '"><div class="item-name">' + item.name + '</div><div class="item-quantity">' + item.picked + '</div></div>' );
                jQuery( parent ).append( v_item );
            }
            else {
                var v_item = jQuery( '<div class="item" data-index="' + index + '"><div class="item-name">' + item.name + '</div><div class="item-quantity">' + item.picked + '</div></div>' );
                jQuery( target_picked ).append( v_item );
            }
        }

    }

    this.pick = function( index, is_ovr ) {
        is_ovr = is_ovr === true ? 1 : 0;
        SKU.push( this.items.unpicked[index].sku );
        //backorder
        var backpref = "";
        if ( this.items.unpicked[index].backorder )
            backpref = "back-";
        //backorder

        ////Bundle with sku instant pick
        var target;
        var parent_index = this.items.unpicked[index].parent;
        if ( parent_index !== -1 )
        {
            this.items.unpicked[parent_index].bundle_start = 1;
            var unpicked_parent = jQuery( '.' + backpref + 'unpicked .parent_item[data-index=' + parent_index + ']' );
            var picked_parent = jQuery( '.' + backpref + 'picked .parent_item[data-index=' + parent_index + ']' );
            var parent = jQuery( '.' + backpref + 'picked .parent_item[data-index=' + parent_index + ']' );
            if ( parent.length !== 0 ) {
                target = parent;
            }
            else
            {
                var v_item = jQuery( '<div class="parent_item" data-index="' + parent_index + '"><div class="item-name">' + this.items.unpicked[parent_index].name + '</div><div class="item-quantity"></div></div>' );
                jQuery( '.' + backpref + 'picked .items' ).append( v_item );
                var target = jQuery( '.' + backpref + 'picked .parent_item[data-index=' + parent_index + ']' );
                this.items.picked[parent_index] = jQuery.extend( this.items.picked[parent_index], this.items.unpicked[parent_index] );
                this.items.picked[parent_index].qty = 0;
            }
            //this.items.unpicked[parent_index].qty -= 1;

        } else
            target = jQuery( '.' + backpref + 'picked .items' );


        var v_item = jQuery( '.' + backpref + 'unpicked div[data-index=' + index + ']' );
        var index = v_item.attr( 'data-index' );
        var unpicked_item_quantity = v_item.find( '.item-quantity' ).eq( 0 );
        if ( typeof ( this.items.picked[index] ) == 'undefined' ) {
            var clone_item = v_item.clone();

            var picked_item_quantity = clone_item.find( '.item-quantity' ).eq( 0 );

            target.append( clone_item );
            var picked = parseInt( this.items.unpicked[index].picked );
            this.items.unpicked[index].picked = picked + 1;

            this.items.unpicked[index].qty -= 1;
            this.items.picked[index] = { };
            this.items.picked[index] = jQuery.extend( this.items.picked[index], this.items.unpicked[index] );

            this.items.picked[index].qty = 1;
            if ( is_ovr )
                this.items.picked[index].is_ovr = is_ovr;

            picked_item_quantity.html( this.items.picked[index].qty )

        } else {
            var picked_item_quantity = jQuery( '.' + backpref + 'picked div[data-index=' + index + ']' ).find( '.item-quantity' ).eq( 0 );
            var picked = parseInt( this.items.unpicked[index].picked );
            this.items.unpicked[index].picked = picked + 1;

            this.items.unpicked[index].qty -= 1;
            this.items.picked[index].qty += 1;
            if ( is_ovr )
                this.items.picked[index].is_ovr = is_ovr;

            picked_item_quantity.html( this.items.picked[index].qty )
        }


        if ( this.items.unpicked[index].isparent === 1 )
        {

            if ( ( typeof ( that.items.unpicked[index].bundle_start ) === 'undefined' ) ) {
                that.items.count_picked--;

                jQuery.each( this.items.unpicked, function( index_b, b ) {

                    if ( b.parent === parseInt( index ) ) {
                        if ( typeof ( that.items.picked[index_b] ) == 'undefined' ) {
                            that.items.unpicked[index_b].qty -= that.items.unpicked[index_b].bundle_qty;
                            that.items.picked[index_b] = { };
                            that.items.picked[index_b] = jQuery.extend( that.items.picked[index_b], that.items.unpicked[index_b] );
                            that.items.picked[index_b].qty = that.items.unpicked[index_b].bundle_qty;
                        } else
                        {
                            that.items.unpicked[index_b].qty -= that.items.unpicked[index_b].bundle_qty;
                            that.items.picked[index_b].qty += that.items.unpicked[index_b].bundle_qty;
                        }
                        jQuery( '.' + backpref + 'picked div[data-index=' + index_b + ']' ).find( '.item-quantity' ).eq( 0 ).html( that.items.picked[index_b].qty );
                        jQuery( '.' + backpref + 'unpicked div[data-index=' + index_b + ']' ).find( '.item-quantity' ).eq( 0 ).html( that.items.unpicked[index_b].qty );
                        that.items.count_picked += that.items.unpicked[index_b].bundle_qty;
                        if ( that.items.unpicked[index_b].qty <= 0 ) {
                            delete that.items.unpicked[index_b];
                        }
                    }

                } )

            } else
            {
                jQuery( '#status-x' ).html( text['bundle children started'] );
                jQuery( '#status-x' ).removeClass().addClass( 'bundle-children-started' );
                return false;
            }
        }



        unpicked_item_quantity.html( this.items.unpicked[index].qty )

        this.items.count_picked++;
        var procent = Math.ceil( ( this.items.count_picked / this.items.count ) * 100 )

        progress_bar.progressbar( "value", procent );

        if ( this.items.unpicked[index].qty == 0 ) {
            delete this.items.unpicked[index];
            v_item.remove();
        }



///// math for correct bundle count 
        var arr = [ ];
        var merge_arr = [ ];
        jQuery.extend( merge_arr, this.items.unpicked );
        jQuery.extend( merge_arr, this.items.picked );

        jQuery.each( merge_arr, function( ai, aitem ) {
            if ( ( parent_index !== -1 ) && ( aitem.parent === parent_index ) ) {
                arr[ai] = 0;
            }
        } )
        jQuery.each( this.items.picked, function( i, eitem ) {
            if ( eitem )
                if ( ( parent_index !== -1 ) && ( eitem.parent === parent_index ) ) {
                    //if ((eitem.qty % eitem.bundle_qty) === 0)

                    arr[i] = parseInt( ( parseInt( eitem.qty, 10 ) / parseInt( eitem.bundle_qty, 10 ) ), 10 );
                    // console.log('eitem', eitem)
                    // console.log('arr[' + i + ']=', arr[i])
                }
        } )
        arr = Object.keys( arr ).map( function( key ) {
            return arr[key]
        } );

        var min = Math.min.apply( null, arr );
//        console.log( '--------------' )
//        console.log('min arr ',arr)
//        console.log( 'qty ' + this.items.unpicked[parent_index].qty )
//        console.log( 'min = ' + min + ' qty = ' + this.items.picked[parent_index].qty )
//        console.log( min > this.items.picked[parent_index].qty )
//        console.log('picked ',this.items.picked)
//        console.log( '--------------' )
        if ( ( parent_index !== -1 ) && ( min > this.items.picked[parent_index].qty ) ) {
            this.items.picked[parent_index].qty += 1;
            this.items.unpicked[parent_index].qty -= 1;
            this.items.unpicked[parent_index].picked = this.items.picked[parent_index].qty;
            unpicked_parent.find( '.item-quantity' ).eq( 0 ).html( this.items.unpicked[parent_index].qty );
            picked_parent.find( '.item-quantity' ).eq( 0 ).html( this.items.picked[parent_index].qty );

//            console.log('delete')

            if ( this.items.unpicked[parent_index].qty == 0 ) {
                delete this.items.unpicked[parent_index];
                unpicked_parent.remove();
//                console.log(this.items.unpicked[parent_index].picked)
//                console.log(this.items.unpicked[parent_index])
            }
        }
        ///end math

        if ( procent == 100 ) {
//            console.log( '---=-=-=-=----' )
//            console.log( procent )
//            console.log( '---=-=-=-=----' )
            if ( this.load_completed ) {
                this.add_log( this.order.id )

            }
            stop_sounds();
            audio_order_complete.play();
            that.status = 'complete'
            that.events.completed.run();
        } else {

        }
        console.log( 'after_pick_unpicked', this.items.unpicked )
        console.log( 'after_pick_picked', this.items.picked )
        that.events.after_pick.run( this.items.unpicked[index] );
    }
    this.clear_picked_items = function() {
        jQuery( '.unpicked .items *' ).remove();
        jQuery( '.picked .items *' ).remove();
        jQuery( '.back-unpicked .items *' ).remove();
        jQuery( '.back-picked .items *' ).remove();
        SKU = [ ];
    }
    this.change_status = function( text, css_class ) {

    }
    this.find_by_sku = function( sku ) {
        if ( sku !== this.override_sku ) {
            var result = false;

            jQuery.each( this.items.unpicked, function( index, item ) {
                if ( typeof ( item ) != 'undefined' ) {
                    if ( sku == item.sku ) {
                        result = index;
                        return false;
                    }
                }
            } )
            if ( result === false ) {
                return false;
            } else {
                return result;
            }
        } else
        {
            jQuery( "#product_qty_over" ).val( '' );
            jQuery( "#product_qty_sku" ).val( "" );
            jQuery( '#product_sku_over' ).val( '' );
            jQuery( '#product_sku_over' ).focus();
            jQuery( '#product_title_over' ).text( '' );
            jQuery( '#product_qty_label_over' ).text( '' );
            jQuery( "#thickbox" ).click();
            resizeTB(450)
        }
    }
    this.search = function() {

        var product_sku = jQuery( '#product_sku' ).val();
        jQuery( '#product_sku' ).val( '' );
        var index = this.find_by_sku( product_sku );
        this.last_search = index;
        if ( index == undefined )
            return;
        else {
            if ( index === false ) {
                stop_sounds();
                audio_item_error.play();
                jQuery( "#product_sku" ).focus();
            } else {
                if ( this.pick( index ) !== false )
                {
                    var procent = Math.ceil( ( this.items.count_picked / this.items.count ) * 100 )
                    if ( procent >= 100 ) {
                        stop_sounds();
                        audio_order_complete.play();
                    } else {
                        stop_sounds();
                        audio_item_success.play();
                        jQuery( "#product_sku" ).focus();
                    }
                }
                else
                {
                    stop_sounds();
                    audio_item_error.play();
                    jQuery( "#product_sku" ).focus();
                    return;
                }
            }

            if ( index === false ) {
                that.events.after_searching.run( false );
            } else {
                that.events.after_searching.run( this.items.unpicked[index] );
            }
        }
    }

    this.search_over = function() {
        var product_sku = jQuery( '#product_sku_over' ).val();
        var qty = jQuery( '#product_qty_over' ).val();
        var error;
        for ( var i = 0; i < qty; i++ ) {
            var index = this.find_by_sku( product_sku );
            if ( index !== false ) {
                this.pick( index, true );
            }
            else
                error = true;
        }
        if ( error )
            alert( "Wrong SKU" );
        else
            jQuery( "#TB_closeWindowButton" ).click();

        if ( index === false ) {
            that.events.after_searching.run( false );
        } else {
            that.events.after_searching.run( this.items.unpicked[index] );
        }
    }

    this.search_processing = function( sku ) {
        var product_sku = sku;
        var index = this.find_by_sku( product_sku );
//        console.log('search_processing: '+index)
        if ( index !== false )
            this.pick( index );
    }

    this.get_item_title = function( index ) {
        var item = this.items.unpicked[index];
        return item.name;
    }

    this.get_item_count_by_sku = function( sku ) {
        var count = 0;
        jQuery.each( this.items.unpicked, function( index, item ) {
            if ( typeof ( item ) != 'undefined' ) {
                if ( sku == item.sku ) {
                    count += parseInt( item.qty );
                }
            }
        } )
        return count;
    }

    this.add_log = function( order_id ) {
        var action = 'add_log';
        jQuery.post( ajax, 'action=p_action&p_act=' + action + '&order_id=' + order_id, function( data ) {
            console.log( data )
        } )
    }
}
