<?php
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class WC_PickingPal {

	public $url_plugin;
	public $path_plugin;
	public $override_sku;
	static private $_instance;

	const metakey_version		 = '_wc_pickingpal_version';
	const metakey				 = '_wc_pickpal_log';
	const metakey_processing	 = '_wc_picking_processing';
	const metakey_last_log_id	 = '_wc_last_log_id';
	const metakey_pick_arr	 = '_wc_pick_arr';
	const metakey_printed		 = '_wc_pick_ticket_printed';

	public $path_template;
	public $url_template;

	/**
	 * 
	 * @return WC_PickingPal
	 */
	static function getInstance() {
		if ( !is_object( self::$_instance ) ) {
			self::$_instance = new WC_PickingPal();
		}
		return self::$_instance;
	}

	public function __construct() {
		$this->override_sku			 = "PP-OVRD-ITM-QTY";
		$this->url_plugin			 = plugin_dir_url( __FILE__ ) . '../';
		$this->path_plugin			 = plugin_dir_path( __FILE__ ) . '../';
		$this->path_views_default	 = plugin_dir_path( __FILE__ ) . "../view/";

		if ( is_admin() ) { // admin actions
			add_action( 'admin_menu', array( $this, 'add_menu' ) );
			add_action( 'admin_init', array( $this, 'register_setting' ) );
			add_action( 'admin_init', array( $this, 'get_action' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'thematic_enqueue_scripts' ) );
			add_action( 'admin_footer-edit.php', array( $this, 'woocommerce_bulk_admin_footer' ), 10 );
			add_action( 'load-edit.php', array( $this, 'woocommerce_custom_bulk_action' ) );
			add_action( 'admin_notices', array( $this, 'woocommerce_custom_bulk_admin_notices' ) );
			add_action( 'woocommerce_admin_order_actions_end', array( $this, 'add_actions' ), 110 );
			add_filter( 'views_edit-shop_order', array( $this, 'woocommerce_views_edit' ), 110 );
			$updater	 = new WC_Pickingpal_Updater();
			$key_update	 = $updater->need_update();
			if ( $key_update !== false AND ! isset( $_REQUEST[ 'do_update_pickingpal' ] ) ) {
				add_action( 'admin_notices', array( $this, 'notice_need_update' ) );
			}

			add_filter( 'posts_where', array( $this, 'posts_where' ) );
		}
	}

	public function activation() {
		
	}

	public function notice_need_update() {
		$this->render( 'notice_need_update' );
	}

	public function register_setting() {
		register_setting( 'woocommerce-pickingpal', 'wc_pickingpal' );
	}

	public function add_menu() {
		add_submenu_page( 'woocommerce', 'PickingPal', 'PickingPal', 'edit_published_pages', 'PickingPal', array( $this, 'render_menu' ) );
	}

	public function render_menu() {
		$url = plugins_url( '../', __FILE__ );
		if ( isset( $_REQUEST[ 'contact' ] ) ) {
			update_option( 'pickingpal-contact', $_REQUEST[ 'contact' ] );
		}
		if ( !empty( $_REQUEST[ 'url_file' ] ) ) {
			update_option( 'pickingpal-logo', $_REQUEST[ 'url_file' ] );
		}
		if ( !empty( $_REQUEST[ 'delete_logo' ] ) ) {
			delete_option( 'pickingpal-logo' );
		}
		if ( !empty( $_REQUEST[ 'fields' ] ) ) {
			$u_fields = $_REQUEST[ 'fields' ];

			update_option( 'wc-picking-pal-fields', $u_fields );
		}
		if ( !empty( $_REQUEST[ 'active_fields' ] ) ) {
			$active_fields = !empty( $_REQUEST[ 'active_fields' ] ) ? $_REQUEST[ 'active_fields' ] : array();
			update_option( 'wc-picking-pal-active-fields', $active_fields );
		}

		if ( isset( $_REQUEST[ 'tab' ] ) and $_REQUEST[ 'tab' ] == 'export' ) {
			$this->remove_not_existing_fields();
		}
		$logo = get_option( 'pickingpal-logo' );

		$this->render( 'main', array( 'logo' => $logo, 'url' => $url, 'WC_PickingPal' => $this, 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
	}

	public function thematic_enqueue_scripts() {

		if ( 'woocommerce_page_PickingPal' == get_current_screen()->id ) {
			wp_enqueue_script( 'jquery-ui-core' );
			wp_enqueue_script( 'jquery-ui-dialog' );
			wp_enqueue_script( 'jquery-ui-tabs' );

			wp_enqueue_script( 'jquery-ui-progressbar' );
			wp_enqueue_script( "callback-woocommerce-pickingpal", plugin_dir_url( __FILE__ ) . '../js/items.js' );

			wp_enqueue_script( "items-woocommerce-pickingpal", plugin_dir_url( __FILE__ ) . '../js/callback.js' );

			wp_enqueue_script( "jquery-tooltip", plugin_dir_url( __FILE__ ) . '../../woocommerce/assets/js/jquery-tiptip/jquery.tipTip.js' );

			wp_enqueue_style( "aaaa", plugin_dir_url( __FILE__ ) . '../../woocommerce/assets/css/admin.css' );

//			wp_register_style( 'bootstrap-css', plugin_dir_url( __FILE__ ) . '../css/bootstrap.min.css', false, NULL, 'all' );
//			wp_enqueue_style( "bootstrap-css" );
			wp_enqueue_style( "wp-jquery-ui-dialog" );
			wp_enqueue_style( "main-woocommerce-pickingpal", plugin_dir_url( __FILE__ ) . '../css/main.css' );
			wp_enqueue_style( "bootsrtap-table", plugin_dir_url( __FILE__ ) . '../css/bootstrap-table.css' );
			wp_enqueue_style( "jquery-woocommerce-pickingpal", plugin_dir_url( __FILE__ ) . '../css/jquery-ui.css' );
			wp_enqueue_media();
			wp_enqueue_script( 'uploader-hook', plugin_dir_url( __FILE__ ) . '../js/uploader-hook.js', array( 'jquery' ) );

			wp_enqueue_script( "tb-show-ext", plugin_dir_url( __FILE__ ) . '../js/tb-show-ext.js' );
		}

		$text = array(
			'product found'				 => __( 'product found', 'woocommerce-pickingpal' ),
			'product not found'			 => __( 'product not found', 'woocommerce-pickingpal' ),
			'bundle children started'	 => __( 'Product bundle scan error', 'woocommerce-pickingpal' ),
			'Scan Order'				 => __( 'Scan Order', 'woocommerce-pickingpal' ),
			'Order Loaded'				 => __( 'Order Loaded', 'woocommerce-pickingpal' ),
			'Order Not Found'			 => __( 'Order Not Found', 'woocommerce-pickingpal' ),
			'Order Loaded (PICKED)'		 => __( 'Order Loaded (PICKED)', 'woocommerce-pickingpal' ),
		);
		wp_localize_script( 'items-woocommerce-pickingpal', 'text', $text );
	}

	public function render( $view, $params = array(), $path_views = null ) {
		extract( $params );
		if ( $path_views ) {
			include $path_views . "$view.php";
		} else {
			include $this->path_views_default . "$view.php";
		}
	}

	public function woocommerce_views_edit( $arr_filter ) {

		$args = array(
			'post_type'		 => 'shop_order',
			'meta_query'	 => array(
				array(
					'key'		 => self::metakey_printed,
					'compare'	 => 'NOT EXISTS'
				),
			),
			'post_status'	 => 'any',
			'posts_per_page' => 1
		);

		$query	 = new WP_Query( $args );
		$count	 = $query->found_posts;

		$status = 'not-printed';

		if ( isset( $_REQUEST[ 'post_status' ] ) AND $_REQUEST[ 'post_status' ] == 'not-printed' ) {
			$class = 'current';
		} else {
			$class = '';
		}
		$text = __( 'Print Pick Tickets', 'woocommerce-pickingpal' );

		if ( $count )
			$arr_filter[ $status ] = "<a href='edit.php?post_status=$status&amp;post_type=shop_order' class='$class'>$text <span class=\"count\">($count)</span></a>";


		return $arr_filter;
	}

	function posts_where( $where ) {

		if ( is_admin() ) {
			global $wpdb;

			if ( isset( $_REQUEST[ 'post_status' ] ) AND $_REQUEST[ 'post_status' ] == 'not-printed' ) {
				$where .= " AND {$wpdb->posts}.ID NOT IN (SELECT post_id FROM  {$wpdb->postmeta} WHERE {$wpdb->postmeta}.meta_key='" . self::metakey_printed . "')";
			}
		}
//		print_r( $where );
		return $where;
	}

	public function woocommerce_bulk_admin_footer() {


		global $post_type;

		if ( 'shop_order' == $post_type ) {
			?>
			<script type="text/javascript">
				jQuery( document ).ready( function( $ ) {
					$( '<option>' ).val( 'print_list' ).text( '<?php _e( 'Print Pick Ticket', 'woocommerce-pickingpal' ) ?>' ).appendTo( "select[name='action']" );
					$( '<option>' ).val( 'print_list' ).text( '<?php _e( 'Print Pick Ticket', 'woocommerce-pickingpal' ) ?>' ).appendTo( "select[name='action2']" )
				} );
			</script>
			<?php
		}
	}

	public function add_actions( $order ) {
		?>
		<a class="button print_list" style="padding: 5px 4px 5px 5px;;" target="_blank" data-tip="<?php _e( 'Print Pick Ticket', 'woocommerce-pickingpal' ) ?>" href="<?php echo wp_nonce_url( admin_url( '?print_list=1&ids[0]=' . $order->id ), 'print_list' ); ?>"><img src="<?php echo $this->url_plugin . 'img/printer.png' ?>" alt="<?php _e( 'Print Pick Ticket', 'woocommerce-pickingpal' ) ?>" width="14"></a>
		<script>
			jQuery( document ).ready( function( $ ) {
				$( 'a.print_list' ).click( function() {
					var href = $( this ).attr( 'href' );
					var w = window.open( href, 'print', 'width=800,height=600' );
					w.focus()
					return false;
				} )
				$( 'a.print_list' ).attr( 'title', '<?php _e( 'Print Pick Ticket', 'woocommerce-pickingpal' ) ?>' )
				// Tooltips
				var tiptip_args = {
					'fadeIn': 50,
					'fadeOut': 50,
					'delay': 200
				};


				$( function() {
					$( ".print_list" ).tipTip( tiptip_args );
				} );
			} )
		</script>
		<?php
	}

	public function woocommerce_custom_bulk_action() {
		$wp_list_table	 = _get_list_table( 'WP_Posts_List_Table' );
		$action			 = $wp_list_table->current_action();

		if ( isset( $_REQUEST[ 'post' ] ) ) {
			$ids = $_REQUEST[ 'post' ];
		} else {
			return;
		}
		switch ( $action ) {
			case 'print_list':

				$sendback = wp_nonce_url( admin_url(), 'print_list' );

				$sendback = add_query_arg( array( 'print_list_msg' => 'ddd', 'print_list' => '1', 'ids' => $ids ), $sendback );

				foreach ( $ids as $id ) {
					add_post_meta( $id, self::metakey_printed, 'Y', true );
				}

				break;
			default : return;
		}
		wp_redirect( $sendback );

		exit();
	}

	public function woocommerce_custom_bulk_admin_notices() {

		global $post_type, $pagenow;

		if ( $pagenow == 'edit.php' && $post_type == 'shop_order' && isset( $_REQUEST[ 'print_list_msg' ] ) ) {
			$message = $_REQUEST[ 'print_list_msg' ];
			echo "<div class=\"updated\"><p>{$message}</p></div>";
		}
	}

	/**
	 * 
	 * @param type $template
	 * @return array('url','dir')
	 */
	public function woocommerce_pickingpal_template( $template ) {

		$templates = array();
		if ( file_exists( trailingslashit( get_stylesheet_directory() ) . 'woocommerce/woocommerce-pickingpal-template/' . $template . '.php' ) ) {
			$templates[ 'url' ]	 = trailingslashit( get_stylesheet_directory_uri() ) . 'woocommerce/woocommerce-pickingpal-template/';
			$templates[ 'dir' ]	 = trailingslashit( get_stylesheet_directory() ) . 'woocommerce/woocommerce-pickingpal-template/';
		} else {
			$templates[ 'url' ]	 = $this->url_plugin . 'woocommerce-pickingpal-template/';
			$templates[ 'dir' ]	 = $this->path_plugin . 'woocommerce-pickingpal-template/';
		}

		return $templates;
	}

	public function get_action() {

		if ( isset( $_GET[ 'print_list' ] ) ) {
			$orders = array();
			if ( isset( $_GET[ 'ids' ] ) ) {

				foreach ( $_GET[ 'ids' ] as $id ) {
					$orders[] = new WC_Order( $id );
				}
			}
			switch ( $_GET[ 'print_list' ] ) {
				case 1:
					$template_name = 'template_list';
					foreach ( $orders as $order ) {
						add_post_meta( $order->id, self::metakey_printed, 'Y', true );
					}
					break;
				case 2:
					$id				 = $_GET[ 'ids' ][ 0 ];
					$template_name	 = 'template_slip';
					$order_items	 = $this->get_order_items( $id );
					$pick_arr		 = get_post_meta( $id, self::metakey_pick_arr, true );
					$template		 = $this->woocommerce_pickingpal_template( $template_name );
					$this->render( $template_name, array( 'orders' => $orders, 'url' => $template[ 'url' ], 'order_items' => $order_items, 'pick_arr' => $pick_arr ), $template[ 'dir' ] );
					exit();
					break;
				case 3:
					$template_name	 = 'barcode';
					$barcode		 = $this->override_sku;
					$this->render( $template_name, array( 'barcode' => $barcode, 'url_plugin' => $this->url_plugin ) );
					exit();
					break;
			}

			$template = $this->woocommerce_pickingpal_template( $template_name );
			$this->render( $template_name, array( 'orders' => $orders, 'url' => $template[ 'url' ] ), $template[ 'dir' ] );
			exit();
		}
		if ( isset( $_REQUEST[ 'p_act' ] ) ) {
			switch ( $_REQUEST[ 'p_act' ] ) {

				case 'export':
					if ( isset( $_REQUEST[ 'products' ] ) ) {
						$ids		 = $_REQUEST[ 'products' ];
						$products	 = $this->get_products( $ids );
						$this->export_csv( $products );
					}
					break;
			}
		}
		if ( isset( $_REQUEST[ 'do_update_pickingpal' ] ) ) {

			$updater = new WC_Pickingpal_Updater();

			$key_update = $updater->need_update();

			if ( $key_update !== false ) {
				$updater->start_update( $key_update );
			}
		}
	}

	public function get_products( $ids ) {
		$products = array();

		$active_fields	 = get_option( 'wc-picking-pal-active-fields' );
		$fields			 = array();
		foreach ( $active_fields as $field => $v ) {
			$fields[] = $field;
		}
		$fields[]	 = 'qty';
		$products[]	 = $fields;
		foreach ( $ids as $key => $id ) {
			$product = wc_get_product( $id );
			switch ( $product->product_type ) {
				case 'variation':
					$this->get_product_variation( $product, $active_fields, $products );
					break;
				default:
					$this->get_product_simple( $product, $active_fields, $products );
			}
		}

		return $products;
	}

	public function get_product_variation( $product, $active_fields, &$products ) {
		$attr = $product->get_variation_attributes();

		foreach ( $active_fields as $field => $v ) {
			$products[ $key + 1 ][ $field ] = '';
			if ( $field == 'sku' ) {
				$products[ $key + 1 ][ 'sku' ] = $product->get_sku();
			}
			if ( $field == 'name' ) {
				$products[ $key + 1 ][ 'name' ] = $product->get_title();
			}
			if ( $field == 'price' ) {

				if ( !empty( $product->price ) ) {
					$products[ $key + 1 ][ 'price' ] = '$' . number_format( $product->price, 2 );
				}
			}
			if ( self::is_custom_field( $field ) ) {
				$products[ $key + 1 ][ $field ] = apply_filters( 'wc_pickingpal_custom_field_value', $product, $field );
			}
			if ( isset( $attr[ "attribute_pa_$field" ] ) ) {
				if ( empty( $attr[ "attribute_pa_$field" ] ) ) {

					$f = array_map( function($t) {
						return $t->name;
					}, get_terms( "pa_$field" ) );
					$products[ $key + 1 ][ $field ] = implode( $f, ', ' );
				} else {
					$products[ $key + 1 ][ $field ] = $attr[ "attribute_pa_$field" ];
				}
			}
		}

		foreach ( $active_fields as $field => $v ) {
			if ( empty( $products[ $key + 1 ][ $field ] ) ) {

				$vs = wc_get_product_terms( $product->id, "pa_$field" );

				if ( $vs ) {

					$products[ $key + 1 ][ $field ] = implode( $vs, ', ' );
				}
			}
		}
		$qty = get_post_meta( $id, 'qty', true );

		$products[ $key + 1 ][ 'qty' ] = empty( $qty ) ? 100 : $qty;
	}

	public function get_product_simple( $product, $active_fields, &$products ) {
		$attr = $product->get_attributes();
		foreach ( $active_fields as $field => $v ) {
			$products[ $key + 1 ][ $field ] = '';
			if ( $field == 'sku' ) {
				$products[ $key + 1 ][ 'sku' ] = $product->get_sku();
			}
			if ( $field == 'name' ) {
				$products[ $key + 1 ][ 'name' ] = $product->get_title();
			}
			if ( $field == 'price' ) {

				if ( !empty( $product->price ) ) {
					$products[ $key + 1 ][ 'price' ] = '$' . number_format( $product->price, 2 );
				}
			}
			if ( self::is_custom_field( $field ) ) {
				$products[ $key + 1 ][ $field ] = apply_filters( 'wc_pickingpal_custom_field_value', $product, $field );
			}
			if ( isset( $attr[ "pa_$field" ] ) ) {

				$t		 = get_terms( "pa_$field" );
				$terms	 = '';
				if ( $t ) {
					$terms = array_map( function($term) {
						return $term->name;
					}, $t );
					$terms = implode( $terms, ', ' );
				}
				$products[ $key + 1 ][ $field ] = $terms;
			}
		}
		$qty							 = get_post_meta( $id, 'qty', true );
		$products[ $key + 1 ][ 'qty' ]	 = empty( $qty ) ? 100 : $qty;
	}

	public static function is_custom_field( $field ) {
		$custom_fields = apply_filters( 'wc_pickingpal_custom_fields', array() );
		if ( isset( $custom_fields[ $field ] ) ) {
			return true;
		} else {
			return false;
		}
	}

	public function export_csv( $data_rows ) {
		$filename	 = 'products.csv';
		$fh			 = @fopen( 'php://output', 'w' );

		header( 'Cache-Control: must-revalidate, post-check=0, pre-check=0' );
		header( 'Content-Description: File Transfer' );
		header( 'Content-type: text/csv' );
		header( "Content-Disposition: attachment; filename={$filename}" );
		header( 'Expires: 0' );
		header( 'Pragma: public' );

		foreach ( $data_rows as $data_row ) {
			fputcsv( $fh, $data_row );
		}
		fclose( $fh );
		die();
	}

	public function ajax_action() {
		$url = plugins_url( '../', __FILE__ );
		if ( isset( $_REQUEST[ 'p_act' ] ) ) {
			switch ( $_REQUEST[ 'p_act' ] ) {

				case 'load_order':
					if ( isset( $_REQUEST[ 'order_id' ] ) ) {
						$order_id	 = $_REQUEST[ 'order_id' ];
						$order_items = $this->get_order_items( $order_id );
						echo json_encode( $order_items );
					}
					break;
				case 'pick':
					$post_id	 = $_REQUEST[ 'id' ];
					$sku		 = $_REQUEST[ 'sku' ];
					$pick_arr	 = $_REQUEST[ 'pick_arr' ];
					$r			 = add_post_meta( $post_id, self::metakey_processing, $sku, true );
					if ( !$r ) {
						update_post_meta( $post_id, self::metakey_processing, $sku );
					}
					$r			 = get_post_meta( $post_id, self::metakey_pick_arr, true );
					if ( $r )
						$pick_arr	 = array_replace_recursive( $r, $pick_arr );

					update_post_meta( $post_id, self::metakey_pick_arr, $pick_arr );
					/*
					  if ( $_REQUEST[ 'is_ovr' ] ) {
					  global $wpdb;

					  $log_data = array( 'ovr' => array( $sku[ 0 ] => 1 ) );
					  $this->update_log( $post_id, $log_data );
					  } */

					if ( isset( $_REQUEST[ 'item' ] ) ) {
						$order_id	 = $_REQUEST[ 'order_id' ];
						$item		 = $_REQUEST[ 'item' ];
						if ( $item[ 'backordered' ] ) {
							do_action( 'pick_complete_back_ordered', $order_id, $item );
						} else {
							do_action( 'pick_complete_in_stock', $order_id, $item );
						}
						global $wpdb;
						if ( $item[ 'picked' ] == 1 ) {
							//$log_data = array( 'ovr' => array( $item['parent'] .'---'. $sku[ 0 ] => 0 ) );
							//$this->update_log( $order_id, $log_data );
						}

						if ( $item[ 'is_ovr' ] ) {
							// fill override_sku
							$last_log_id = get_post_meta( $post_id, self::metakey_last_log_id, true );
							$log		 = get_post_meta_by_id( $last_log_id );
							if ( $log ) {
								if ( !empty( $log->meta_value[ 'ovr' ] ) )
									$ovr												 = $log->meta_value[ 'ovr' ];
								else
									$ovr												 = array();
								$ovr [ $item[ 'parent' ] . '---' . $item[ 'sku' ] ]	 = 1;
								$this->update_log( $order_id, array( 'ovr' => $ovr ) );
							}
						}
					}
					break;
				case 'add_log':
					if ( isset( $_REQUEST[ 'order_id' ] ) ) {
						$order_id	 = $_REQUEST[ 'order_id' ];
						$r			 = delete_post_meta( $order_id, self::metakey_processing );
//						$last_log_id = get_post_meta($post_id,self::metakey_last_log_id,true);
//						$log = get_post_meta_by_id($last_log_id);
						$log_data	 = array( 'processing' => 0 );
						$r			 = $this->update_log( $order_id, $log_data );
						do_action( 'pick_complete_full_order', $order_id );
//						print_r( $r );
//						echo "delete post meta ($order_id) $r";
//						echo "add log";
					}
					break;
				case 'table_load':
					echo json_encode( $this->table_load( $_REQUEST ) );
					break;
				case 'wp_log_table':
					global $hook_suffix;
					$hook_suffix = 'woocommerce_page_PickingPal';
					include 'class-wc-pickingpal-list-log.php';
					$log		 = new WC_PickingPal_List_Log();
					$log->output_report();
					break;
				case 'wp_export_table':
					global $hook_suffix;
					$hook_suffix = 'woocommerce_page_PickingPal';
					include 'class-wc-pickingpal-list-export.php';
					$log		 = new WC_PickingPal_List_Export();
					$log->output_report();
					break;
				case 'save_qty':
					if ( isset( $_REQUEST[ 'post_id' ] ) AND isset( $_REQUEST[ 'value' ] ) ) {
						$post_id = $_REQUEST[ 'post_id' ];
						$value	 = $_REQUEST[ 'value' ];
						$r		 = update_post_meta( $post_id, 'qty', $value );
						echo json_encode( $r );
					};
					break;
				case 'reset_order':
					$order_id	 = $_REQUEST[ 'order_id' ];
					$r			 = delete_post_meta( $order_id, self::metakey_processing );
					delete_post_meta( $order_id, self::metakey_pick_arr );
					add_post_meta( $order_id, self::metakey_processing, array(), true );
					$this->add_log( $order_id );
					//alex fixed
					$log_data	 = array( 'ovr' => array() );
					$this->update_log( $order_id, $log_data );
					echo "delete post meta ($order_id) $r";
//					die();
					break;
				case 'load_order_log':
					if ( isset( $_REQUEST[ 'order_id' ] ) ) {
						global $wpdb;
						$order_id	 = $_REQUEST[ 'order_id' ];
//						$log		 = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM {$wpdb->prefix}postmeta WHERE post_id=%d AND meta_key=%s ORDER BY meta_id DESC LIMIT 1", $order_id, self::metakey ) );
						$last_log_id = get_post_meta( $order_id, self::metakey_last_log_id, true );
						$log		 = get_post_meta_by_id( $last_log_id );
						$order_items = $this->get_order_items( $order_id );
						$pick_arr	 = get_post_meta( $order_id, self::metakey_pick_arr, true );

						$this->render( 'order-log', array( 'order_items' => $order_items, 'log' => $log, 'order_id' => $order_id, 'pick_arr' => $pick_arr ) );
					}
					break;
			}
		}
		die();
	}

	public function get_order_items( $order_id ) {
		global $wpdb;

//		delete_post_meta($order_id, self::metakey_processing);


		$order				 = new WC_Order( @apply_filters( 'woocommerce_shortcode_order_tracking_order_id', $order_id ) );
		$order->post_status	 = wc_get_order_status_name( $order->post_status );
		$items				 = $order->get_items();
		if ( !$order->post ) {
			$order_items = array(
				'order' => $order,
			);
			return $order_items;
		}

		$bundles			 = array();
		$bundled_product_idx = array();

//			print_r($items);die();

		$products = array();
		foreach ( $items as $index => $item ) {
			$product		 = $order->get_product_from_item( $item );
			$backordred_qty	 = isset( $item[ 'Backordered' ] ) ? $item[ 'Backordered' ] : 0;
			$index			 = count( $products );

			// new bundle started 
			if ( !empty( $item[ 'bundled_items' ] ) ) {
				$bundle_sku				 = $product->get_sku();
				$bundle_key				 = $item[ 'bundle_cart_key' ];
				$bundles[ $bundle_key ]	 = array(
					'index'			 => array( $index ),
					'qty'			 => $item[ 'qty' ],
					'sku'			 => $bundle_sku,
					'backordered'	 => $backordred_qty,
				);

				$bundles[ $bundle_key ] [ 'index' ]		 = array();
				$bundles[ $bundle_key ] [ 'qty' ]		 = $item[ 'qty' ];
				$index									 = count( $products );
				$bundles[ $bundle_key ] [ 'index' ][]	 = $index;
				// add product
				$products[ $index ]						 = array(
					'sku'			 => $bundle_sku,
					'name'			 => $product->get_formatted_name(),
					'picked'		 => 0,
					'parent'		 => -1,
					'qty'			 => $item[ 'qty' ],
					'isparent'		 => 1,
					'count'			 => 0,
					'backordered'	 => $backordred_qty,
				);

				//make MANY products
				$bundled_items = unserialize( $item[ 'bundled_items' ] );
				foreach ( $bundled_items as $b_item ) {
					$index											 = count( $products ); // adds placeholder products
					$products[ $index ]								 = array();
					$bundled_product_idx[ $bundle_key ][ $b_item ]	 = $index;
				}
			} elseif ( !empty( $item[ 'bundled_by' ] ) ) {
				$bundle		 = $bundles[ $item[ 'bundled_by' ] ]; // got bundle
				$bundle_key	 = $item[ 'bundle_cart_key' ];
				foreach ( $bundle[ 'index' ] as $i => $bundle_item_idx ) {
					$product_index				 = $bundled_product_idx[ $item[ 'bundled_by' ] ][ $bundle_key ];
					//fill placeholder items
					$products[ $product_index ]	 = array(
						'sku'			 => $product->get_sku(),
						'name'			 => $product->get_formatted_name(),
						'picked'		 => 0,
						'parent'		 => $bundle_item_idx,
						'qty'			 => $item[ 'qty' ] /** $bundle[ 'qty' ] */,
						'bundle_qty'	 => $item[ 'qty' ] / $bundle[ 'qty' ],
						'backordered'	 => $backordred_qty,
					);
					$products[ $bundle_item_idx ][ 'count' ] += 1;
				}
			} else {
				$products[ $index ] = array(
					'sku'			 => $product->get_sku(),
					'name'			 => $product->get_formatted_name(),
					'picked'		 => 0,
					'parent'		 => -1,
					'qty'			 => $item[ 'qty' ],
					'backordered'	 => $backordred_qty,
				);
			}
		}

		$sql	 = $wpdb->prepare( "SELECT COUNT(*)
			FROM {$wpdb->prefix}postmeta 
			WHERE {$wpdb->prefix}postmeta.meta_key = '%s' and {$wpdb->prefix}postmeta.post_id='%d'", self::metakey, $order->id );
		$picked	 = (int) $wpdb->get_var( $sql );

		if ( !empty( $products ) )
			if ( !$picked ) {
				$r = add_post_meta( $order_id, self::metakey_processing, array(), true );
				$this->add_log( $order_id );
			}

		$last_log	 = $this->get_last_log( $order_id );
		$processing	 = 0;
		if ( $last_log ) {
			$processing = $last_log[ 'processing' ];
		}

		$order_items = array(
			'order'			 => $order,
			'picked'		 => ($picked ? !$processing : $picked),
			'products'		 => $products,
			'override_sku'	 => $this->override_sku,
			'processing'	 => $processing
		);
		///=-=-=-=-=-=-=-

		$m = get_post_meta( $order_id, self::metakey_processing, true );

		if ( !$processing ) {
			$m = array();
			foreach ( $products as $pr ) {
				for ( $i = 0; $i < $pr[ 'qty' ]; $i++ ) {
					$m[] = $pr[ 'sku' ];
				}
			}
		}

		$order_items[ 'SKU' ] = $m;
		///=-=-=-=-=-=-=-
//		if ( !$picked ) {
//			$this->add_log( $order->id );
//            var_dump('1');
//			$sql		 = $wpdb->prepare( "INSERT INTO {$wpdb->prefix}postmeta SET post_id='%d', meta_key='%s', meta_value='%s'", $order->id, self::metakey, serialize( array(
//				'tracking_order_id'	 => $order->get_order_number(),
//				'order_id'			 => $order->id,
//				'display_name'		 => wp_get_current_user()->display_name,
//				'date_scanned'		 => current_time( 'mysql' ),
//				'order_quantity'	 => array_sum( array_map( function($elem) {
//					return $elem[ 'qty' ];
//				}, $products ) ),
//				'scanned_by' => get_current_user_id(),
//			) ) );
//			$wpdb->get_results( $sql );
//		}
		return $order_items;
	}

	public function add_log( $order_id ) {
		global $wpdb;
		$last_log	 = $this->get_last_log( $order_id, false );
		$processing	 = 0;
		if ( $last_log ) {
			$processing = $last_log->meta_value[ 'processing' ];
		}
		if ( $processing )
			return $last_log->meta_id;

		$order			 = new WC_Order( $order_id );
		$date_scanned	 = current_time( 'mysql' );
		$order_quantity	 = $order->get_item_count();
		$scanned_by		 = get_current_user_id();
		$user			 = wp_get_current_user();
		$data			 = array(
			'tracking_order_id'	 => $order->get_order_number(),
			'order_id'			 => $order_id,
			'display_name'		 => $user->display_name,
			'date_scanned'		 => $date_scanned,
			'order_quantity'	 => $order_quantity,
			'scanned_by'		 => $scanned_by,
			'processing'		 => 1,
		);
		$last_log_id	 = add_post_meta( $order_id, self::metakey, $data, false );

		add_post_meta( $order_id, self::metakey_last_log_id, $last_log_id, true ) or
		update_post_meta( $order_id, self::metakey_last_log_id, $last_log_id );

		return $last_log_id;
	}

	public function update_log( $order_id, array $arr_data, $add = true ) {
		$log	 = (array) $this->get_last_log( $order_id, FALSE );
		$meta_id = $log[ 'meta_id' ];
		if ( $log ) {
			if ( $add ) {
				$log = array_merge( $log[ 'meta_value' ], $arr_data );
			} else {
				$log = $arr_data;
			}
			return update_metadata_by_mid( 'post', $meta_id, $log, self::metakey );
//			$r = $this->update_meta_log( $meta_id, $log );
		}
		return false;
	}

//	public function update_meta_log( $meta_id, $arr_log ) {
//
//		global $wpdb;
//		$log = serialize( $arr_log );
//		$pr	 = $wpdb->prepare( "UPDATE {$wpdb->prefix}postmeta SET meta_value=%s WHERE meta_id=%d", $log, $meta_id );
//		$r	 = $wpdb->query( $pr );
//		var_dump( $wpdb->last_query );
//		return $r;
//	}

	public function get_last_log( $order_id, $value = true ) {
		$last_log_id = get_post_meta( $order_id, self::metakey_last_log_id, true );
		$log		 = get_post_meta_by_id( $last_log_id );
		if ( $log ) {
			if ( $value ) {
				return $log->meta_value;
			}
		}

		return $log;
	}

	public function update_existing( &$array_source, &$array_destination ) {

		foreach ( $array_source as $index => $value ) {

			if ( isset( $array_destination[ $index ] ) and empty( $array_destination[ $index ] ) ) {
				$array_destination[ $index ] = $value;
			}
		}
	}

	public function remove_not_existing_fields() {
		$a_f = get_option( 'wc-picking-pal-active-fields' );
		$f	 = $this->get_fields();
		foreach ( $a_f as $index => $value ) {
			if ( !isset( $f[ $index ] ) ) {
				unset( $a_f[ $index ] );
			}
		}
		update_option( 'wc-picking-pal-active-fields', $a_f );
	}

	public function get_fields() {
		global $wpdb;

		$fields = array(
			'sku'	 => '',
			'name'	 => '',
			'price'	 => '',
		);

		$attributes = $wpdb->get_results( "SELECT `{$wpdb->prefix}woocommerce_attribute_taxonomies`.attribute_name  FROM `{$wpdb->prefix}woocommerce_attribute_taxonomies`" );
		foreach ( $attributes as $key => $attribute ) {
			$fields[ $attribute->attribute_name ] = '';
		}
		$custom_fields = apply_filters( 'wc_pickingpal_custom_fields', array() );
		if ( $custom_fields ) {
			$fields = array_merge( $fields, $custom_fields );
		}
		$s_fields = get_option( 'wc-picking-pal-fields' );
		if ( $s_fields ) {
			$this->update_existing( $s_fields, $fields );
			update_option( 'wc-picking-pal-fields', $fields );
		}
		return $fields;
	}

}
