<?php

class WC_Pickingpal_Updater {

	private $arr_update;

	public function __construct() {
		$this->arr_update = array(
			'1.2.0',
		);
	}

	public function need_update() {
		
		$current_version = get_option( WC_PickingPal::metakey_version );
		foreach ( $this->arr_update as $key => $value ) {
//			var_dump($current_version,$value);
			if ( version_compare( $current_version, $value, '<' ) ) {
				return $key;
			}
		}
		return false;
	}

	public function start_update( $key_update ) {

		$m_key = count( $this->arr_update );

		for ( $i = $key_update; $i < $m_key; $i++ ) {
			$v = str_replace( '.', '_', $this->arr_update[ $i ] );
			$this->{'update_' . $v}();
			update_option( WC_PickingPal::metakey_version, $this->arr_update[ $i ] );
		}
		
	}

	public function update_1_2_0() {

		$args = array(
			'post_type'		 => 'shop_order',
			'post_status'	 => 'any',
			'posts_per_page'=>-1
		);

		$query = new WP_Query( $args );

		foreach ( $query->posts as $post ) {
			add_post_meta( $post->ID, WC_PickingPal::metakey_printed, 'Y', true );
		}
	}



}
