<?php

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( !class_exists( 'WP_List_Table' ) ) {
	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
}
require_once(ABSPATH . 'wp-admin/includes/template.php' );
if ( !class_exists( 'WP_Screen' ) ) {
	require_once( ABSPATH . 'wp-admin/includes/screen.php' );
}

class WC_PickingPal_List_Log extends WP_List_Table {

	public function __construct() {

		parent::__construct( array(
			'singular'	 => __( 'item', 'woocommerce-pickingpal' ),
			'plural'	 => __( 'items', 'woocommerce-pickingpal' ),
			'ajax'		 => true
		) );
	}

	/**
	 * Output the report
	 */
	public function output_report() {
		$this->prepare_items();

		echo '<form method="post" id="pickingpal">';

		$this->search_box( __( 'Search', 'woocommerce-pickingpal' ), 'search' );
		$this->display();

		echo '</form>';
	}

	/**
	 * get_columns function.
	 */
	public function get_columns() {
		$columns = array(
			'order_id'		 => __( 'Order#', 'woocommerce-pickingpal' ),
			'date_scanned'	 => __( 'Date scanned', 'woocommerce-pickingpal' ),
//			'order_quantity' => __( 'Order quantity', 'woocommerce-pickingpal' ),
			'display_name'	 => __( 'Scanned by', 'woocommerce-pickingpal' ),
		);

		return $columns;
	}

	public function prepare_items() {
		global $wpdb;


		$columns	 = $this->get_columns();
		$hidden		 = array( '' );
		$sortable	 = $this->get_sortable_columns();

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$current_page	 = absint( $this->get_pagenum() );
		$per_page		 = 10;

		$where	 = $wpdb->prepare( "WHERE meta_key = '%s'", WC_PickingPal::metakey );
		$limit	 = '';
		if ( !empty( $_REQUEST[ 's' ] ) ) {
			$s		 = '%' . esc_sql( $_REQUEST[ 's' ] ) . '%';
			$where	 = $wpdb->prepare( "WHERE meta_key = '%s' AND meta_value LIKE  '%s'", WC_PickingPal::metakey, $s );
		}

		$sql = "SELECT {$wpdb->prefix}postmeta.meta_value  FROM {$wpdb->prefix}postmeta $where";
		$r	 = $wpdb->get_results( $sql, ARRAY_A );

		$amount_rows = 0;
		$data		 = array();
		foreach ( $r as &$d_row ) {
			$data[ $amount_rows ]				 = unserialize( $d_row[ 'meta_value' ] );
			$data[ $amount_rows ][ 'order_post_id' ]	 = $data[ $amount_rows ][ 'order_id' ];// id as number!
			$order								 = new WC_Order( $data[ $amount_rows ][ 'order_id' ] );
			$data[ $amount_rows ][ 'order_id' ]	 = substr( $order->get_order_number(), 0 );
//			$p									 = get_post_meta( $order->id, WC_PickingPal::metakey_processing, true );
//			$data[ $amount_rows ][ 'processing' ] =$p; is_array( $p ) ? count( $p ) : 0;
			$amount_rows++;
		}
		if ( !isset( $_REQUEST[ 'orderby' ] ) ) {
			$_REQUEST[ 'orderby' ]	 = 'date_scanned';
			$_REQUEST[ 'order' ]	 = 'desc';
		}

		$direction	 = isset( $_REQUEST[ 'orderby' ] ) ? $_REQUEST[ 'order' ] : '';
		$order		 = $_REQUEST[ 'orderby' ];

		usort( $data, function($a, $b) use ($order, $direction) {
			if ( $direction == 'asc' ) {
				return strcmp( $a[ $order ], $b[ $order ] );
			} else {
				return strcmp( $b[ $order ], $a[ $order ] );
			}
		} );

		if ( isset( $_REQUEST[ 'paged' ] ) ) {
			$start_offset = ($_REQUEST[ 'paged' ] - 1) * $per_page;
		} else {
			$start_offset = 0;
		}
		$data = array_slice( $data, $start_offset, $per_page );
//		var_dump( $data );

		$this->items = $data;
		/**
		 * Pagination
		 */
		$this->set_pagination_args( array(
			'total_items'	 => $amount_rows,
			'per_page'		 => $per_page,
			'total_pages'	 => ceil( $amount_rows / $per_page )
		) );
	}

	function column_default( $item, $column_name ) {
		switch ( $column_name ) {
			case 'order_id':
				return $item[ $column_name ];
			case 'date_scanned':
				$r = "<a class=\"modal_open thickbox\" href=\"#TB_inline?width=0&height=0&inlineId=modal&order_id={$item[ 'order_post_id' ]}\" data-id=\"{$item[ 'order_post_id' ]}\">" . $item[ $column_name ] . "</a>";
//				var_dump( $item[ 'processing' ] );	
				if ( !$item[ 'processing' ] ) {
					$r.='<span class="dashicons dashicons-yes"></span>';
				}
				return $r;

			case 'order_quantity':
				return $item[ $column_name ];
			case 'display_name':
				return $item[ $column_name ];
			default:
				return print_r( $item, true ); //Show the whole array for troubleshooting purposes
		}
	}

	public function get_sortable_columns() {
		$columns = array(
			'order_id'		 => array( 'order_id', false ),
			'date_scanned'	 => array( 'date_scanned', false ),
			'order_quantity' => array( 'order_quantity', false ),
			'display_name'	 => array( 'display_name', false ),
		);
		return $columns;
	}

}
